<?php 

//Function para Criar XML Receiving LOGs
function fis_cria_xml_log($id, $ori_path, $ori_file, $new_path, $new_file, $reason, $remark) {
    //Conectando ao Banco de Dados
    $conexao = new Conexao('mysql');

    $insert = array('xlg_xml_id'   => $id,
                    'xlg_ori_path' => $ori_path,
                    'xlg_ori_file' => $ori_file,
                    'xlg_new_path' => $new_path,
                    'xlg_new_file' => $new_file,
                    'xlg_date'     => date('Y-m-d H:i:s'),
                    'xlg_rsn_id'   => $reason,
                    'xlg_remark'   => $remark);

    $mysql_retorno = $conexao->mysql_insert('FIS_XML_LOG', $insert, '', FALSE);

    if ($mysql_retorno == 1) {

        //Criando Diretorio de Destino caso ele não exista
        if (!file_exists($new_path)) {
            mkdir($new_path, 0777, true);
        }

        //Movendo Arquivo
        if (rename($ori_path.$ori_file,$new_path.$new_file)) {
            return 1;
        } else {
            return "Erro ao mover arquivo";
        }

    } else {
        //Erro ao gravar
        return "Erro ao gravar Log";
    }
}

//Funcao para Carrega XML (NF-e)
function fis_carrega_xml($xml_ori_dir, $xml_dst_dir, $xml_name){
    //Carregando XML na memoria
    $xml= @simplexml_load_file($xml_ori_dir.$xml_name);   

    //Se nao e XML valido
    if (!$xml) {
        //Imprime na tela
        echo "..Erro ao abrir arquivo!<BR>";

        //Gera Log
        $xml_log = fis_cria_xml_log(  'NULL', 
                                    $xml_ori_dir, 
                                    $xml_name, 
                                    $xml_dst_dir."erro", 
                                    $xml_name, 
                                    'INVALIDO', 
                                    "Erro ao abrir arquivo!");
    } else {

        //Conectando ao Banco de Dados
        $conexao = new Conexao('mysql');

        //Variáveis da NFe
        $infnfe     = $xml->NFe->infNFe;
        $attributes = $infnfe->attributes();   
        $nfe_id     = substr(strval($attributes['Id']),3,44);
        $emit_CNPJ  = strval($infnfe->emit->CNPJ);
        $dest_CNPJ  = strval($infnfe->dest->CNPJ);

        //Verificar se fornecedor não cadastrado
        $sql_spl   = "SELECT spl_id FROM MDT_SUPPLIER
                        WHERE spl_cnpj   = '$emit_CNPJ'
                        AND   spl_status = 1";
        $query_spl = $conexao->sql($sql_spl);
        if ($conexao->numRows($query_spl) == 0) {
            //Preparando CNPJ
            $gst_id = formataCNPJ($emit_CNPJ);

            //Definindo URL da API do QAD
            $api_qad = buscaCodigo('SYS_API','api_url','ALL');

            //Buscando Fornecedor atualizado no QAD
            $sup_url = $api_qad."supplier/read_one.php?gst_id=".$gst_id;
            $sup_json = read_api($sup_url);

            //Decodificando Retorno
            $sup_array = json_decode($sup_json, true);  

            //Verificando Retorno de erro
            if (!isset($sup_array['error'])) {

                //verificando qtd de registros
                if (isset($sup_array)) {

                    //removendo caracteres de formatacao
                    $replace_arr=array(".","/","-"," ");
                    $gst_id = str_replace($replace_arr, "", $sup_array['gst_id']);
                    $pst_id = str_replace($replace_arr, "", $sup_array['pst_id']);

                    //Atualizando Fornecedor
                    $dados_i =  array(  'spl_id'            => $sup_array['code'], 
                                        'spl_desc'          => $sup_array['name'],
                                        'spl_cnpj'          => $gst_id, 
                                        'spl_ie'            => $pst_id,
                                        'spl_addr_line1'    => $sup_array['street1'],
                                        'spl_addr_line2'    => $sup_array['street2'],
                                        'spl_addr_line3'    => $sup_array['street3'],
                                        'spl_city'          => $sup_array['city'],
                                        'spl_stt_id'        => $sup_array['state_code'], 
                                        'spl_zipc'          => $sup_array['zipcode'], 
                                        'spl_create_usr_id' => 1000,
                                        'spl_create_dt'     => date('Y-m-d H:i:s'), 
                                        'spl_status'        => $sup_array['active']);

                    $dados_u =  array(  'spl_desc'          => $sup_array['name'],
                                        'spl_cnpj'          => $sup_array['gst_id'], 
                                        'spl_ie'            => $sup_array['pst_id'],
                                        'spl_addr_line1'    => $sup_array['street1'],
                                        'spl_addr_line2'    => $sup_array['street2'],
                                        'spl_addr_line3'    => $sup_array['street3'],
                                        'spl_city'          => $sup_array['city'],
                                        'spl_stt_id'        => $sup_array['state_code'], 
                                        'spl_zipc'          => $sup_array['zipcode'], 
                                        'spl_modify_usr_id' => 1000,
                                        'spl_modify_dt'     => date('Y-m-d H:i:s'), 
                                        'spl_status'        => $sup_array['active']);
                    //Executando Insert
                    $mysql_retorno = $conexao->mysql_insert('MDT_SUPPLIER', $dados_i, $dados_u, FALSE);

                    //Verificando Sucesso
                    if ($mysql_retorno == 1) {
                        echo "..Fornecedor Cadastrado/Atualizado!<br>";
                    } else {
                        echo "..Erro ao Cadastrar/Atualizar Fornecedor.<brR>";
                    }
                } else {
                    echo "..Fornecedor não cadastrado!<BR>";
                }
            } else {
                //Retornando erro da API
                echo "..".$sup_array['error']."<br>";
            }
        } else {
            echo "..Fornecedor já cadastrado!<br>";
        }

        //Buscando Sites Cadastrados
        $sql_sit   = "SELECT sit_id FROM MDT_SITE 
                        WHERE sit_cnpj   = '$dest_CNPJ'
                        AND   sit_oper   = 1
                        AND   sit_status = 1"; 
        $query_sit = $conexao->sql($sql_sit);

        if ($conexao->numRows($query_sit) == 1) {

            //Resgatando Codigo do Site
            $sit = $conexao->retorno($query_sit);
            $sit_id = $sit['sit_id'];

            echo "..NF-e Key: ".$nfe_id."... ";

            //Preparando Variaveis
            $xml_path = $xml_dst_dir.$sit_id."/";
            $xml_file = $nfe_id.".xml";

            //Coletando informacao da pagina
            $dados_i = array(   'xml_id'            => $nfe_id,
                                'xml_type'          => "NFe",
                                'xml_path'          => $xml_path,
                                'xml_file'          => $xml_file,
                                'xml_create_usr_id' => 1000,
                                'xml_create_dt'     => date('Y-m-d H:i:s'),
                                'xml_status'        => 1);
            $dados_u = array(   'xml_id'            => $nfe_id,
                                'xml_type'          => "NFe",
                                'xml_path'          => $xml_path,
                                'xml_file'          => $xml_file,
                                'xml_modify_usr_id' => 1000,
                                'xml_modify_dt'     => date('Y-m-d H:i:s'),
                                'xml_status'        => 1);

            //Executando Insert
            $mysql_retorno = $conexao->mysql_insert('FIS_XML', $dados_i, $dados_u, FALSE);

            //Se Recebimento foi registrado corretamente
            if ($mysql_retorno == 1) { 

                $dados_insert = array(  'xnf_NFe_id'        => $nfe_id,
                                        'xnf_ide_cNF'       => strval($infnfe->ide->cNF),
                                        'xnf_ide_natOp'     => strval($infnfe->ide->natOp),
                                        'xnf_ide_mod'       => strval($infnfe->ide->mod),
                                        'xnf_ide_serie'     => strval($infnfe->ide->serie),
                                        'xnf_ide_nNF'       => strval($infnfe->ide->nNF),
                                        'xnf_ide_dhEmi'     => converteDataXML(strval($infnfe->ide->dhEmi)),
                                        'xnf_ide_dhSaiEnt'  => converteDataXML(strval($infnfe->ide->dhSaiEnt)),
                                        'xnf_emit_CNPJ'     => strval($infnfe->emit->CNPJ),
                                        'xnf_emit_xNome'    => addslashes(strval($infnfe->emit->xNome)),
                                        'xnf_emit_xFant'    => addslashes(strval($infnfe->emit->xFant)),
                                        'xnf_emit_xLgr'     => addslashes(strval($infnfe->emit->enderEmit->xLgr)),
                                        'xnf_emit_nro'      => strval($infnfe->emit->enderEmit->nro),
                                        'xnf_emit_xBairro'  => addslashes(strval($infnfe->emit->enderEmit->xBairro)),
                                        'xnf_emit_cMun'     => converteDecVazio(strval($infnfe->emit->enderEmit->cMun)),
                                        'xnf_emit_xMun'     => addslashes(strval($infnfe->emit->enderEmit->xMun)),
                                        'xnf_emit_UF'       => strval($infnfe->emit->enderEmit->UF),
                                        'xnf_emit_CEP'      => converteDecVazio(strval($infnfe->emit->enderEmit->CEP)),
                                        'xnf_emit_cPais'    => converteDecVazio(strval($infnfe->emit->enderEmit->cPais)),
                                        'xnf_emit_xPais'    => strval($infnfe->emit->enderEmit->xPais),
                                        'xnf_emit_fone'     => strval($infnfe->emit->enderEmit->fone),
                                        'xnf_emit_IE'       => strval($infnfe->emit->IE),
                                        'xnf_dest_CNPJ'     => strval($infnfe->dest->CNPJ),
                                        'xnf_dest_xNome'    => addslashes(strval($infnfe->dest->xNome)),
                                        'xnf_dest_xLgr'     => addslashes(strval($infnfe->dest->enderDest->xLgr)),
                                        'xnf_dest_nro'      => strval($infnfe->dest->enderDest->nro),
                                        'xnf_dest_xBairro'  => addslashes(strval($infnfe->dest->enderDest->xBairro)),
                                        'xnf_dest_cMun'     => converteDecVazio(strval($infnfe->dest->enderDest->cMun)),
                                        'xnf_dest_xMun'     => addslashes(strval($infnfe->dest->enderDest->xMun)),
                                        'xnf_dest_UF'       => strval($infnfe->dest->enderDest->UF),
                                        'xnf_dest_CEP'      => converteDecVazio(strval($infnfe->dest->enderDest->CEP)),
                                        'xnf_dest_cPais'    => converteDecVazio(strval($infnfe->dest->enderDest->cPais)),
                                        'xnf_dest_xPais'    => strval($infnfe->dest->enderDest->xPais),
                                        'xnf_dest_fone'     => strval($infnfe->dest->enderDest->fone),
                                        'xnf_dest_IE'       => strval($infnfe->dest->IE),
                                        'xnf_dest_ISUF'     => strval($infnfe->dest->ISUF),
                                        'xnf_entg_CNPJ'     => strval($infnfe->entrega->CNPJ),
                                        'xnf_entg_xLgr'     => addslashes(strval($infnfe->entrega->xLgr)),
                                        'xnf_entg_nro'      => strval($infnfe->entrega->nro),
                                        'xnf_entg_xBairro'  => addslashes(strval($infnfe->entrega->xBairro)),
                                        'xnf_entg_cMun'     => converteDecVazio(strval($infnfe->entrega->cMun)),
                                        'xnf_entg_xMun'     => strval($infnfe->entrega->xMun),
                                        'xnf_entg_UF'       => strval($infnfe->entrega->UF),
                                        'xnf_totl_vBC'      => converteDecVazio(strval($infnfe->total->ICMSTot->vBC)),
                                        'xnf_totl_vICMS'    => converteDecVazio(strval($infnfe->total->ICMSTot->vICMS)),
                                        'xnf_totl_vBCST'    => converteDecVazio(strval($infnfe->total->ICMSTot->vBCST)),
                                        'xnf_totl_vST'      => converteDecVazio(strval($infnfe->total->ICMSTot->vST)),
                                        'xnf_totl_vProd'    => converteDecVazio(strval($infnfe->total->ICMSTot->vProd)),
                                        'xnf_totl_vFrete'   => converteDecVazio(strval($infnfe->total->ICMSTot->vFrete)),
                                        'xnf_totl_vSeg'     => converteDecVazio(strval($infnfe->total->ICMSTot->vSeg)),
                                        'xnf_totl_vDesc'    => converteDecVazio(strval($infnfe->total->ICMSTot->vDesc)),
                                        'xnf_totl_vII'      => converteDecVazio(strval($infnfe->total->ICMSTot->vII)),
                                        'xnf_totl_vIPI'     => converteDecVazio(strval($infnfe->total->ICMSTot->vIPI)),
                                        'xnf_totl_vPIS'     => converteDecVazio(strval($infnfe->total->ICMSTot->vPIS)),
                                        'xnf_totl_vCONFINS' => converteDecVazio(strval($infnfe->total->ICMSTot->vCONFINS)),
                                        'xnf_totl_vOutro'   => converteDecVazio(strval($infnfe->total->ICMSTot->vOutro)),
                                        'xnf_totl_vNF'      => converteDecVazio(strval($infnfe->total->ICMSTot->vNF)),
                                        'xnf_trns_CNPJ'     => strval($infnfe->transp->transporta->CNPJ),
                                        'xnf_trns_xNome'    => addslashes(strval($infnfe->transp->transporta->xNome)),
                                        'xnf_trns_IE'       => strval($infnfe->transp->transporta->IE),
                                        'xnf_trns_xLgr'     => addslashes(strval($infnfe->transp->transporta->xLgr)),
                                        'xnf_trns_xEnder'   => addslashes(strval($infnfe->transp->transporta->xEnder)),
                                        'xnf_trns_xMun'     => strval($infnfe->transp->transporta->xMun),
                                        'xnf_trns_UF'       => strval($infnfe->transp->transporta->UF),
                                        'xnf_trns_qVol'     => converteDecVazio(strval($infnfe->transp->vol->qVol)),
                                        'xnf_trns_esp'      => strval($infnfe->transp->vol->esp),
                                        'xnf_trns_pesoL'    => converteDecVazio(strval($infnfe->transp->vol->pesoL)),
                                        'xnf_trns_pesoB'    => converteDecVazio(strval($infnfe->transp->vol->pesoB)));

                $mysql_retorno = $conexao->mysql_insert('FIS_XML_NFE', $dados_insert, $dados_insert, FALSE);

                //Se Recebimento foi registrado corretamente
                if ($mysql_retorno == 1) { 

                    echo "Cabeçalho Gravado! <BR>";

                    //Zerando Variáveis
                    $erro_linha = false;
                    $erro_cobr  = false;

                    //Buscando Linhas do XML
                    foreach($infnfe->det as $det) {

                        $det_attributes = $det->attributes();   
                        $nItem          = strval($det_attributes['nItem']);
                        $icms00         = $det->imposto->ICMS->ICMS00;
                        $icms10         = $det->imposto->ICMS->ICMS10;
                        $icms20         = $det->imposto->ICMS->ICMS20;
                        $icms30         = $det->imposto->ICMS->ICMS30;
                        $icms40         = $det->imposto->ICMS->ICMS40;
                        $icms50         = $det->imposto->ICMS->ICMS50;
                        $icms51         = $det->imposto->ICMS->ICMS51;
                        $icms60         = $det->imposto->ICMS->ICMS60;

                        $icms_empty     = true;

                        if (!empty($icms00)) {
                            $icms_empty = false;
                            $ICMS_orig  = converteDecVazio(strval($icms00->orig));
                            $ICMS_CST   = converteDecVazio(strval($icms00->CST));
                            $ICMS_modBC = converteDecVazio(strval($icms00->modBC));
                            $ICMS_vBC   = converteDecVazio(strval($icms00->vBC));
                            $ICMS_pICMS = converteDecVazio(strval($icms00->pICMS));
                            $ICMS_vICMS = converteDecVazio(strval($icms00->vICMS));
                        }		

                        if (!empty($icms10)) {
                            $icms_empty = false;                            
                            $ICMS_orig  = converteDecVazio(strval($icms10->orig));
                            $ICMS_CST   = converteDecVazio(strval($icms10->CST));
                            $ICMS_modBC = converteDecVazio(strval($icms10->modBC));
                            $ICMS_vBC   = converteDecVazio(strval($icms10->vBC));
                            $ICMS_pICMS = converteDecVazio(strval($icms10->pICMS));
                            $ICMS_vICMS = converteDecVazio(strval($icms10->vICMS));
                        }		

                        if (!empty($icms20)) {
                            $icms_empty = false;                            
                            $ICMS_orig  = converteDecVazio(strval($icms20->orig));
                            $ICMS_CST   = converteDecVazio(strval($icms20->CST));
                            $ICMS_modBC = converteDecVazio(strval($icms20->modBC));
                            $ICMS_vBC   = converteDecVazio(strval($icms20->vBC));
                            $ICMS_pICMS = converteDecVazio(strval($icms20->pICMS));
                            $ICMS_vICMS = converteDecVazio(strval($icms20->vICMS));
                        }		

                        if (!empty($icms30)) {
                            $icms_empty = false;                            
                            $ICMS_orig  = converteDecVazio(strval($icms30->orig));
                            $ICMS_CST   = converteDecVazio(strval($icms30->CST));
                            $ICMS_modBC = converteDecVazio(strval($icms30->modBC));
                            $ICMS_vBC   = converteDecVazio(strval($icms30->vBC));
                            $ICMS_pICMS = converteDecVazio(strval($icms30->pICMS));
                            $ICMS_vICMS = converteDecVazio(strval($icms30->vICMS));
                        }		

                        if (!empty($icms40)) {
                            $icms_empty = false;                            
                            $ICMS_orig  = converteDecVazio(strval($icms40->orig));
                            $ICMS_CST   = converteDecVazio(strval($icms40->CST));
                            $ICMS_modBC = converteDecVazio(strval($icms40->modBC));
                            $ICMS_vBC   = converteDecVazio(strval($icms40->vBC));
                            $ICMS_pICMS = converteDecVazio(strval($icms40->pICMS));
                            $ICMS_vICMS = converteDecVazio(strval($icms40->vICMS));
                        }		

                        if (!empty($icms50)) {
                            $icms_empty = false;                            
                            $ICMS_orig  = converteDecVazio(strval($icms50->orig));
                            $ICMS_CST   = converteDecVazio(strval($icms50->CST));
                            $ICMS_modBC = converteDecVazio(strval($icms50->modBC));
                            $ICMS_vBC   = converteDecVazio(strval($icms50->vBC));
                            $ICMS_pICMS = converteDecVazio(strval($icms50->pICMS));
                            $ICMS_vICMS = converteDecVazio(strval($icms50->vICMS));
                        }		

                        if (!empty($icms51)) {
                            $icms_empty = false;                            
                            $ICMS_orig  = converteDecVazio(strval($icms51->orig));
                            $ICMS_CST   = converteDecVazio(strval($icms51->CST));
                            $ICMS_modBC = converteDecVazio(strval($icms51->modBC));
                            $ICMS_vBC   = converteDecVazio(strval($icms51->vBC));
                            $ICMS_pICMS = converteDecVazio(strval($icms51->pICMS));
                            $ICMS_vICMS = converteDecVazio(strval($icms51->vICMS));
                        }		

                        if (!empty($icms60)) {
                            $icms_empty = false;                            
                            $ICMS_orig  = converteDecVazio(strval($icms60->orig));
                            $ICMS_CST   = converteDecVazio(strval($icms60->CST));
                            $ICMS_modBC = converteDecVazio(strval($icms60->modBC));
                            $ICMS_vBC   = converteDecVazio(strval($icms60->vBC));
                            $ICMS_pICMS = converteDecVazio(strval($icms60->pICMS));
                            $ICMS_vICMS = converteDecVazio(strval($icms60->vICMS));
                        }		

                        if($icms_empty) {
                            $ICMS_orig  = 0;
                            $ICMS_CST   = 0;
                            $ICMS_modBC = 0;
                            $ICMS_vBC   = 0;
                            $ICMS_pICMS = 0;
                            $ICMS_vICMS = 0;
                        }		

                        echo "....$ICMS Linha: ".$nItem."... ";

                        $dados_insert = array(  'xni_NFe_id'          => $nfe_id,
                                                'xni_det_nItem'       => $nItem,
                                                'xni_cProd'           => addslashes(strval($det->prod->cProd)),
                                                'xni_xProd'           => addslashes(strval($det->prod->xProd)),
                                                'xni_NCM'             => strval($det->prod->NCM),
                                                'xni_CFOP'            => converteDecVazio(strval($det->prod->CFOP)),
                                                'xni_uCom'            => strval($det->prod->uCom),
                                                'xni_qCom'            => converteDecVazio(strval($det->prod->qCom)),
                                                'xni_vUnCom'          => converteDecVazio(strval($det->prod->vUnCom)),
                                                'xni_vProd'           => converteDecVazio(strval($det->prod->vProd)),
                                                'xni_uTrib'           => strval($det->prod->uTrib),
                                                'xni_qTrib'           => converteDecVazio(strval($det->prod->qTrib)),
                                                'xni_vUnTrib'         => converteDecVazio(strval($det->prod->vUnTrib)),
                                                'xni_ICMS_orig'       => $ICMS_orig,
                                                'xni_ICMS_CST'        => $ICMS_CST,
                                                'xni_ICMS_modBc'      => $ICMS_modBC,
                                                'xni_ICMS_vBc'        => $ICMS_vBC,
                                                'xni_ICMS_pICMS'      => $ICMS_pICMS,
                                                'xni_ICMS_vICMS'      => $ICMS_vICMS,
                                                'xni_IPI_cEnq'        => strval($det->imposto->IPI->cEnq),
                                                'xni_IPI_CST'         => strval($det->imposto->IPI->IPITrib->CST),
                                                'xni_IPI_vBc'         => converteDecVazio(strval($det->imposto->IPI->IPITrib->vBc)),
                                                'xni_IPI_pIPI'        => converteDecVazio(strval($det->imposto->IPI->IPITrib->pIPI)),
                                                'xni_IPI_vIPI'        => converteDecVazio(strval($det->imposto->IPI->IPITrib->vIPI)),
                                                'xni_PIS_CST'         => strval($det->imposto->PIS->PISAliq->CST),
                                                'xni_PIS_vBC'         => converteDecVazio(strval($det->imposto->PIS->PISAliq->vBC)),
                                                'xni_PIS_pPIS'        => converteDecVazio(strval($det->imposto->PIS->PISAliq->pPIS)),
                                                'xni_PIS_vPIS'        => converteDecVazio(strval($det->imposto->PIS->PISAliq->vPIS)),
                                                'xni_COFINS_CST'      => strval($det->imposto->COFINS->COFINSAliq->CST),
                                                'xni_COFINS_vBC'      => converteDecVazio(strval($det->imposto->COFINS->COFINSAliq->vBC)),
                                                'xni_COFINS_pCOFINS'  => converteDecVazio(strval($det->imposto->COFINS->COFINSAliq->pCOFINS)),
                                                'xni_COFINS_vCOFINS'  => converteDecVazio(strval($det->imposto->COFINS->COFINSAliq->vCOFINS)),
                                                'xni_xPed'            => strval($det->prod->xPed),
                                                'xni_nItemPed'        => converteDecVazio(strval($det->prod->nItemPed)));

                        $mysql_retorno = $conexao->mysql_insert('FIS_XML_NFE_ITEM', $dados_insert, $dados_insert, FALSE);

                        //Se Recebimento foi registrado corretamente
                        if ($mysql_retorno == 1) { 

                            echo "Gravada! <BR>";

                        } else {
                            echo $mysql_retorno;
                            $erro_linha = true;
                        }                            
                    }

                    if ($erro_linha == false) {

                        //Sucesso
                        $xml_log = fis_cria_xml_log(  $nfe_id, 
                                                    $xml_ori_dir, 
                                                    $xml_name, 
                                                    $xml_path, 
                                                    $xml_file, 
                                                    'SUCESSO', 
                                                    "Gerado com Sucesso!");

                        if ($xml_log == 1) {
                            echo "..Movido com sucesso!<BR>";
                        } else {
                            echo "..Falha ao Mover!<BR>";
                        }
                    } else {
                        //Erro ao gravar
                        $xml_log = fis_cria_xml_log(  $nfe_id, 
                                                    $xml_ori_dir, 
                                                    $xml_name, 
                                                    $xml_dst_dir."erro/", 
                                                    $xml_name, 
                                                    'ERRO', 
                                                    "Falha ao Gravar! Encontrado erro na gravação das linhas");

                        if ($xml_log == 1) {
                            echo "..Movido para ERRO (Falha ao Gravar! Encontrado erro na gravação das linhas)!<BR>";
                        } else {
                            echo "..Falha ao Mover!<BR>";
                        }                        
                    }


                    //Buscando Informações de Fatura
                    if (!empty($infnfe->cobr->dup)) {
                        foreach($infnfe->cobr->dup as $dup) {
    
                            echo "....Duplicatas: ".$dup->nDup."... ";

                            $dados_insert = array(  'xnc_NFe_id'          => $nfe_id,
                                                    'xnc_nDup'            => strval($dup->nDup),
                                                    'xnc_dVenc'           => strval($dup->dVenc),
                                                    'xnc_vDup'            => converteDecVazio($dup->vDup));

                            $mysql_retorno = $conexao->mysql_insert('FIS_XML_NFE_COBR', $dados_insert, $dados_insert, FALSE);

                            //Se Recebimento foi registrado corretamente
                            if ($mysql_retorno == 1) { 

                                echo "Gravada! <BR>";

                            } else {
                                echo $mysql_retorno;
                                $erro_cobr = true;
                            }                            
                        }

                        if ($erro_cobr == false) {
                                echo "..Salva com sucesso!<BR>";
                        } else {
                                echo "..Falha ao salvar!<BR>";                        
                        }
                    }
                } else {
                    echo $mysql_retorno;
                }
            } else {

                echo $mysql_retorno;
            } 
        } else {

            //Erro ao Gravar (CNPJ Dest Inválido)
            $xml_log = fis_cria_xml_log(  $nfe_id, 
                                          $xml_ori_dir, 
                                          $xml_name, 
                                          $xml_dst_dir."erro/", 
                                          $xml_name, 
                                          'ERRO', 
                                          "CNPJ Dest nao compativel com CNPJ Sites Zeiss");

            if ($xml_log == 1) {
                echo "..Movido para ERRO (CNPJ Dest nao compativel com CNPJ Sites Zeiss)!<BR>";
            } else {
                echo "..Falha ao Mover!<BR>";
            }                        
        }
    }
}


function fis_monta_filtro_sql($cod_table,$cod_field,$filtro){

    //Conectando ao Banco de Dados
    $conexao = new Conexao('mysql');

    //Realizando Consulta
    $sql_cod = "SELECT cod_id,cod_value FROM SYS_CODE
                    WHERE cod_type   = 'CODES'
                    AND   cod_table  = '$cod_table'
                    AND   cod_field  = '$cod_field'
                    AND   cod_status = 1
                    ORDER BY cod_id";
    //Buscando Dados
    $query_cod = $conexao->sql($sql_cod);

    //Verificando se localizou registros
    if ($conexao->numRows($query_cod) > 0) {
        //Preparando filtro SQL
        $retorno = " AND $filtro IN (";

        //Obtendo Array de Registros
        while($cod = $conexao->retorno($query_cod)){
        
            //Complementando filtro
            $retorno .= $cod['cod_id'].",";
        }

        //Finalizando Filtro
        $retorno = substr($retorno,0,-1).") ";
    } else {
        //Retornando Default
        $retorno = " AND $filtro IS NULL";
    }

    //Retornando Resultado
    return $retorno;
}
?>