<?
/* Funcões padrões do sistema */

//Incluindo Classes
require_once 'includes/inc_class_moeda.php';

//Soma Tempos
function somaTempo($tempo1,$tempo2) {

        //Prepara Variavel
        $segundos = 0;

        //Explode o tempo1 e soma os segundos
        list( $h1, $m1, $s1 ) = explode( ':', $tempo1); 
        $segundos += $h1 * 3600;
        $segundos += $m1 * 60;
        $segundos += $s1;

        //Explode o tempo2 e soma os segundos
        list( $h2, $m2, $s2 ) = explode( ':', $tempo2);
        $segundos += $h2 * 3600;
        $segundos += $m2 * 60;
        $segundos += $s2;

        //Realizando as contas
        $horas = floor( $segundos / 3600 ); 
        $segundos %= 3600; 
        $minutos = floor( $segundos / 60 );
        $segundos %= 60;

        //Preenchendo zeros
        $horas    = str_pad($horas, 2, "0", STR_PAD_LEFT);
        $minutos  = str_pad($minutos, 2, "0", STR_PAD_LEFT);
        $segundos = str_pad($segundos, 2, "0", STR_PAD_LEFT);

        return "{$horas}:{$minutos}:{$segundos}";        
}

//Busca opção default para campo
function buscaDefault($table,$field,$id='*'){
        //Conecta ao banco
	$conexao = new Conexao('mysql');

	$sql = $conexao->sql("SELECT cod_value FROM SYS_CODE
                                WHERE   cod_type   = 'DEFAULT' AND
                                        cod_table  = '$table'  AND
                                        cod_field  = '$field'  AND
                                        cod_id     = '$id'     AND
                                        cod_status = 1");

        if ($conexao->numRows($sql) == 1) {
	        $linha = $conexao->retorno($sql);

	        return $linha[0];
        } else {
                return "";
        }
        
}

//Busca opção codigos para campo
function buscaCodigo($table,$field,$id='*') {
        //Conecta ao banco
	$conexao = new Conexao('mysql');

	$sql = $conexao->sql("SELECT cod_value FROM SYS_CODE
                                WHERE   cod_type   = 'CODES' AND
                                        cod_table  = '$table'  AND
                                        cod_field  = '$field'  AND
                                        cod_id     = '$id'     AND
                                        cod_status = 1");

        if ($conexao->numRows($sql) == 1) {
	        $linha = $conexao->retorno($sql);

	        return $linha[0];
        } else {
                return "";
        }
        
}

//Busca Periodo do Calendário
function buscaPeriodo( $tipo, $ano, $mes){
        //Conecta ao banco
	$conexao = new Conexao('mysql');

        //Realiza Busca no banco
	$sql = $conexao->sql("SELECT    per_start_dt AS start_dt,
                                        per_end_dt   AS end_dt
                                FROM ADM_CALENDAR_PERIOD JOIN ADM_CALENDAR
                                        ON per_cld_id = cld_id
                                WHERE per_dtp_name = '$tipo'
                                AND   cld_year     = '$ano'
                                AND   cld_month    = '$mes'
                                AND   cld_status   = 1 
                                        ORDER BY cld_id DESC
                                                LIMIT 1", FALSE);

        //Verifica se encontrou
        if ($conexao->numRows($sql) == 1) {

                //Resgata Dados
	        $linha = $conexao->retorno($sql);

                //Retorna Periodo (array)
	        return $linha;

        } else {
                //Monta Array Vazio
                $linha = array('start_dt' => '', 'end_dt' => '');

                //Retorna Vazio
                return "";
        }
}

//Busca Campo Especifico de Tabela
function buscaCampo($table,$field,$where) {
        //Conecta ao banco
	$conexao = new Conexao('mysql');

        //Preparando Where
        foreach ($where as $chave => $valor) {
                //Incrementando campos       
                $campos .= "$chave='$valor' AND ";
        }

        //Removendo ultimo "AND"
        $campos = substr($campos,0,-4);

	$sql = $conexao->sql("SELECT $field FROM $table WHERE $campos", FALSE);

        if ($conexao->numRows($sql) == 1) {
	        $linha = $conexao->retorno($sql);

	        return $linha[$field];
        } else {
                return "";
        }
}

//Busca Detalhes do Usuário
function buscaUsuario($usr_id,$campo){
        //Conecta ao banco
	$conexao = new Conexao('mysql');

	$sql = $conexao->sql("SELECT $campo FROM SYS_USER
                                WHERE   usr_id = '$usr_id'");

        if ($conexao->numRows($sql) == 1) {
	        $linha = $conexao->retorno($sql);

	        return $linha[0];
        } else {
                return "";
        }
        
}

//Função Manipula Anexo
function anexo($action, $doc_tp, $doc_id, $src_file='', $name='', $att_id='') {
        //Extract
        extract($_SESSION);

        //Conecta ao banco
	$conexao = new Conexao('mysql');

        //Preparando inputs
        $doc_tp = strtoupper($doc_tp);

        //Verifica modo da Função
        switch ($action) {
                //Insere Anexo no Sistema
                case 'INSERT':
                        //Buscando um novo codigo disponivel
                        $new_id   = geraId('SYS_ATTACHMENT','att_id');

                        //Preparando Atributos do Anexo
                        $fname    = substr($src_file,strrpos($src_file,"/") + 1);
                        $att_type = strtolower(substr($name,strrpos($name,".") + 1));
                        $att_size = filesize($src_file);

                        //Verificando se temporário (sem documento atrelado)
                        if ($doc_id == "") {

                                //Definindo Destino
                                $destino = DIR_ATTACH."tmp/".$ssn_id."/";

                                //Preparando dados de tabela
                                $dados = array( 'att_id'            => $new_id,
                                                'att_dtp_name'      => 'TMP',
                                                'att_tmp_id'        => $ssn_id,
                                                'att_path'          => $destino,
                                                'att_phy_name'      => $fname,
                                                'att_log_name'      => $name,
                                                'att_type'          => $att_type,
                                                'att_size'          => $att_size,
                                                'att_create_usr_id' => $ssn_user['id'],
                                                'att_create_dt'     => date('Y-m-d H:i:s'));
                        } else {

                                //Definindo Destino
                                $destino = DIR_ATTACH."$doc_tp/$doc_id/";

                                //Preparando dados de tabela
                                $dados = array( 'att_id'            => $new_id,
                                                'att_dtp_name'      => $doc_tp,
                                                'att_doc_id'        => $doc_id,
                                                'att_path'          => $destino,
                                                'att_phy_name'      => $fname,
                                                'att_log_name'      => $name,
                                                'att_type'          => $att_type,
                                                'att_size'          => $att_size,
                                                'att_create_usr_id' => $ssn_user['id'],
                                                'att_create_dt'     => date('Y-m-d H:i:s'));
                        }

			//Cria Diretorio se não existe
			if (!(file_exists($destino))) {
	                	mkdir($destino, 0777, true);
			}

			//Movendo Arquivo para pasta dentro do sistema
                        if (move_uploaded_file($src_file, $destino.$fname)) {

				//Grava Dados do Anexo no Banco de Dados
                                $mysql_retorno = $conexao->mysql_insert('SYS_ATTACHMENT', $dados, '', FALSE);

                                //Retorno da Função
                                return $mysql_retorno;
			} else {

                                //Retorno da Função
                                return "move_file_error";
                        }

                break;

                //Atualiza Anexo no Sistema (temp para doc)
                case 'UPDATE':
                        //Monta Consulta
                        $sql_att = "SELECT      att_id,
                                                att_path,
                                                att_phy_name
                                        FROM SYS_ATTACHMENT 
                                        WHERE att_dtp_name = 'TMP'
                                        AND   att_tmp_id   = '$ssn_id'";

                        //Executando consulta
                        $query_att = $conexao->sql($sql_att,FALSE);

                        //Verificando se encontrou
                        if ($conexao->numRows($query_att) > 0) {

                                //Definindo Destino
                                $destino = DIR_ATTACH."$doc_tp/$doc_id/";

			        //Cria Diretorio se não existe
			        if (!(file_exists($destino))) {
	                        	mkdir($destino, 0777, true);
			        }

                                //Preparando Dados
                                $dados = array( 'att_dtp_name'      => $doc_tp,
                                                'att_doc_id'        => $doc_id,
                                                'att_tmp_id'        => 'NULL',
                                                'att_path'          => $destino,
                                                'att_modify_usr_id' => $ssn_user['id'],
                                                'att_modify_dt'     => date('Y-m-d H:i:s'));

                                //Regatando dados
                                while ($linha = $conexao->retorno($query_att)) {

                                        //Preparando variaveis
                                        $src_file = $linha['att_path'].$linha['att_phy_name'];
                                        $dst_file = $destino.$linha['att_phy_name'];

			                //Movendo Arquivo para pasta dentro do sistema
                                        if (rename($src_file, $dst_file)) {

                                                //Preparando Filtro
                                                $filtro = "att_id = ".$linha['att_id'];

				                //Grava Dados do Anexo no Banco de Dados
                                                $mysql_retorno = $conexao->mysql_update('SYS_ATTACHMENT', $dados, $filtro, FALSE);

			                }                       
                                }
                        }
                        
                break;

                //Remove Anexo do documento
                case 'DELETE':
                        //Monta Consulta
                        $sql_att = "SELECT      att_id,
                                                att_path,
                                                att_phy_name
                                        FROM SYS_ATTACHMENT 
                                        WHERE att_id = '$att_id'";

                        //Executando consulta
                        $query_att = $conexao->sql($sql_att,FALSE);

                        //Verificando se encontrou
                        if ($conexao->numRows($query_att) == 1) {

                                //Regatando dados
                                $linha = $conexao->retorno($query_att);

                                //Preparando variaveis
                                $src_file = $linha['att_path'].$linha['att_phy_name'];

                                //Verificando se arquivo Existe
                        	if (file_exists($src_file)) {

                                        //Remove arquivo
                                        if (unlink($src_file)){

                                                //Preparando Filtro
                                                $filtro = "att_id = ".$linha['att_id'];

				                //Grava Dados do Anexo no Banco de Dados
                                                $mysql_retorno = $conexao->mysql_delete('SYS_ATTACHMENT', $filtro, FALSE);

                                        }
                                }
                        }

                break;

                //Remove todos os Anexos do Documento
                case 'DELETE_ALL':
                        //Monta Consulta
                        $sql_att = "SELECT      att_id,
                                                att_path,
                                                att_phy_name
                                        FROM SYS_ATTACHMENT 
                                        WHERE att_dtp_name = '$doc_tp'
                                        AND   att_doc_id   = '$doc_id'";

                        //Executando consulta
                        $query_att = $conexao->sql($sql_att,FALSE);

                        //Verificando se encontrou
                        if ($conexao->numRows($query_att) == 1) {

                                //Regatando dados
                                while ($linha = $conexao->retorno($query_att)) {

                                        //Preparando variaveis
                                        $src_file = $linha['att_path'].$linha['att_phy_name'];

                                        //Verificando se arquivo Existe
                                	if (file_exists($src_file)) {

                                                //Remove arquivo
                                                if (unlink($src_file)){

                                                        //Preparando Filtro
                                                        $filtro = "att_id = ".$linha['att_id'];

				                        //Grava Dados do Anexo no Banco de Dados
                                                        $mysql_retorno = $conexao->mysql_delete('SYS_ATTACHMENT', $filtro, FALSE);

                                                        //Retorno da Função
                                                        return $mysql_retorno;
			                        } else {

                                                        //Retorno da Função
                                                        return "delete_file_error";

                                                }
                                        }
                                }
                        }

                break;

        }
}

//Converte Valor para o formato do MYSQL
function converteValor($valor) {
    $remover = array('R$ ', '.');
    $retorno1 = str_replace($remover, '', $valor);
    
    return str_replace(',', '.', $retorno1);
}

//Converte Data para o formato do MYSQL
function converteData($data) {
            return implode("-", array_reverse(explode("/", $data)));
}

//Formata numeros para Português
function formataNum($num,$casas=2) {
        return number_format($num,$casas,",",".");
}

//Formata Numeros Multiplos para Português
function formataMultiplo($num,$med='',$base=1000,$casas=1) {

        //Verificando Unidade Padrão
        switch ($med) {
                case 'K': $num = ($num / ($base * 1)); break;
                case 'M': $num = ($num / ($base * 2)); break;
                case 'G': $num = ($num / ($base * 3)); break;
        }

        //Retorno
        return number_format($num,$casas,",",".");
}

//Formata Data para Português
function formataData($full_time) {

        //Fragmentando data completa    
        $day = substr($full_time, 8, 2);
        $mon = substr($full_time, 5, 2);
        $yea = substr($full_time, 0, 4);
    
        if (($day == '00') or ($day == '') or ($mon == '00') or ($mon == '') or ($yea == '00') or ($yea == '')) {
                return $full_time;
        } else {
                return $day . '/' . $mon . '/' . $yea;
        }
}


//Formata Tempo
function formataTempo($time,$tipo="HM",$naozero=true) {

        //Preparando Tipo
        $tipo = strtoupper($tipo);

        //Explodindo lista
        list($hr,$mn,$sg) = explode(":",$time);

        //Definindo Defaults
        if ($hr == "") { $hr = "00"; }
        if ($mn == "") { $mn = "00"; }
        if ($sg == "") { $sg = "00"; }

        //Retornando conforme o tipo
        switch ($tipo) {
                case "HM":         
                        $retorno = $hr.":".$mn;
                        break;
                case "H":
                        $retorno = $hr;
                        break;
        }

        //verificando se não zerado habilitado
        if ($naozero) {

                //Limpando Retorno Zerado
                if (($retorno <> "00") and ($retorno <> "00:00")) {
                        return $retorno;
                } else {
                        return "";
                }
        } else {

                //Retornando Resultado
                return $retorno;
        }
}


//Gera numero de ID da solicitação
function geraId($tabela,$chave){

        //Conecta ao banco
	$conexao = new Conexao('mysql');

        //ID inicial
	$sql_id_from = $conexao->sql("SELECT IFNULL((SELECT cfg_value FROM STR_CONFIG 
					WHERE cfg_variable = CONCAT('$tabela','_ID_FROM') 
					AND   cfg_status   = 1),0)");
	$linha = $conexao->retorno($sql_id_from);
	$id_from =  $linha[0];

        //ID final (desativado)
	$sql_id_to = $conexao->sql("SELECT IFNULL((SELECT cfg_value FROM STR_CONFIG 
					WHERE cfg_variable = CONCAT('$tabela','_ID_TO') 
					AND   cfg_status   = 1),0)");
	$linha = $conexao->retorno($sql_id_to);
	$id_to =  $linha[0];

        //Gerando novo ID                       
	$sql = $conexao->sql("SELECT IFNULL( MAX($chave), $id_from) + 1 AS id FROM $tabela");
	$linha = $conexao->retorno($sql);
	return $linha[0];
}

//Funcao para criar caixa de opcoes (select)
function options($nome, $array, $atual, $modulo = null, $class = null, $required = false, $codigo = null, $disabled = null) {
    
        //Requerido
        if ($required == true) {
                $required = "required='required'";
        } else {
                $required = '';
        }
    
        //Desabilitado
        if ($disabled == true) {
                $disabled = "disabled";
        } else {
                $disabled = '';
        }
    
        //Abre Select
        $select.= "<select name='$nome' id='$nome' codigo='$codigo' class='$class' $required $disabled>";

        //Monta Options do Select
        if (isset($array)) {
                //Resgatando opções
                foreach ($array as $valor => $desc) {
                        
                        //Verificando Seleção
                        if (strtoupper($atual) == strtoupper($valor)) {
                                $sel = "selected";
                        } else {
                                $sel = "";
                        }

                        //Escreve Option 
                        $select.= "<option value='$valor' $sel>$desc</option>";
                }
        }

        //Fecha Select
        $select.= "</select>";
    
        // retorna ao select pronto
        return $select;
}

//Função para Criar caixinha de Calendário
function calendar($nome, $atual, $class = '', $dias = null) {
    
    // cria o select
    $input = "
            <div class='input-group'>
              <input type='text' 
                    class='calendar form-control $class' 
                       id='$nome' 
                     name='$nome' 
                 readonly='true' 
                    value='$atual'
              placeholder='".date('d/m/Y')."'>
              <span class='input-group-addon'><span class='icon-calendar'></span></span>
            </div>
            <script>
                $(function() {
                        // Travar Key menos a TAB
                        $( \"#$nome\" ).keydown( function ( e ) {
                                // Act on the event 
                                console.log( \"keyup called\" );
                                var code = e.keyCode || e.which;

                                if ( code == \"9\" ) {
                                        //Tab
                                } else {
                                        return false;
                                }
                        } );

                        $( \"#$nome\" ).datepicker({
                                showButtonPanel: false,
                                changeMonth: false,
                                changeYear: false,
                                showWeek: false,
                                dateFormat: \"dd/mm/yy\"";

    if ($dias != null) {
        $input.= ",
        minDate: $dias";
    }

    $input.= "
                        });
                });
            </script>";
    
    // retorna ao select já com o ajax
    return $input;

}

?>
