<?php

// Requisitos
require_once 'inc_session.php';
require_once 'inc_class-core.php';
require_once 'inc_class-hack.php';

// Conexao padrao
class Conexao extends Core {

        private $_MySQL_server   = "localhost"; 
        private $_MySQL_user     = "sigced";
        private $_MySQL_password = "high123";
        private $_MySQL_database = "SARP";

        // Variaveis Principais
        private $_base    = "mysql";
        private $_query;
        private $_link;
        private $debug    = false;

        //Metodo Construtor
        public function __construct() {

                //Chamando Metodo de Conexao
                $this->conexao();
        }

        //Metodo de Conexao
        protected function conexao() {
                //Conectando ao RDBMS
                $this->_link = mysqli_connect(  $this->_MySQL_server, 
                                                $this->_MySQL_user, 
                                                $this->_MySQL_password) 
                               or die("Servidor do banco de dados: " . $this->_MySQL_server . " nao esta respondendo.");

                //Selecionando DB da Conexao
                $this->conBase();
        }

        //Metodo de Seleção de DB
        protected function conBase() {

                //Selecionando o DB
                mysqli_select_db($this->_link, $this->_MySQL_database) or die("Erro na hora de selecionar o banco");

                //Parametrizando Conexao com o banco de Dados
                mysqli_query($this->_link, "SET NAMES 'utf8'");
                mysqli_query($this->_link, 'SET character_set_connection=utf8');
                mysqli_query($this->_link, 'SET character_set_client=utf8');
                mysqli_query($this->_link, 'SET character_set_results=utf8');
        }

        //Metodo Provisório para compatibilidade com antigo "mysql_field_name" 
        public function mysqli_field_name($result, $field_offset)
        {
                $properties = mysqli_fetch_field_direct($result, $field_offset);
                return is_object($properties) ? $properties->name : false;
        }

        //Metodo Provisório para compatibilidade com antigo "mysql_result"
        public function mysqli_result($result,$row,$field=0) {
                if ($result===false) return false;

                if ($row>=mysqli_num_rows($result)) return false;

                if (is_string($field) && !(strpos($field,".")===false)) {
                        $t_field=explode(".",$field);
                        $field=-1;
                        $t_fields=mysqli_fetch_fields($result);
                        for ($id=0;$id<mysqli_num_fields($result);$id++) {
                                if ($t_fields[$id]->table==$t_field[0] && $t_fields[$id]->name==$t_field[1]) {
                                        $field=$id;
                                        break;
                                }
                        }

                        if ($field==-1) return false;

                }

                mysqli_data_seek($result,$row);

                $line=mysqli_fetch_array($result);

                return isset($line[$field])?$line[$field]:false;
        }

        //Metodo consulta sql
        public function sql($query, $debug = 0) {

                //Verifica se Debug Ativo
                if ($debug == 0) {
                        //Retorna Consulta
                        $this->_query = $query;
                        return mysqli_query($this->_link, $this->_query);
                } else {
                        //Retorna Comando de Consulta
                        $this->_query = $query;
                        return ($this->_query);
                }
        }

        //Metodo Transforma o Select em Json
        public function mysql2json($query, $indented  = false, $utf8 = 2) {

                //Realizando Consulta
                $query = mysqli_query($this->_link, $query) or die('MyJSON - SQLtoJSON - Cannot make query');

                //Verifica qtd de registros encontrados
                if (!$numFields = mysqli_num_fields($query)) {
                        $this->errors[] = 'SQLtoJSON - Cannot get number of MySQL fields';

                        return false;
                }

                $fields = array();

                for ($i = 0; $i < $numFields; $i++) { 
                        $fields[$i] = $this->mysqli_field_name($query, $i);
                }

                if (!$numRows = mysqli_num_rows($query)) {
                        $this->errors[] = 'SQLtoJSON - Cannot get number of MySQL rows';

                        return 0;
                }

                $res = array();
                for ($i   = 0; $i < $numRows; $i++) {
                        $res[$i]   = array();
                        for ($j = 0; $j < count($fields); $j++) { 
                                switch ($utf8) {
                                        case 1:
                                        // $res[$i][$fields[$j]] = (mysql_result($query, $i, $j));
                                        $res[$i][$fields[$j]] = utf8_encode($this->mysqli_result($query, $i, $j));
                                        break;

                                        case 0:
                                        $res[$i][$fields[$j]] = utf8_decode($this->mysqli_result($query, $i, $j));
                                        break;

                                        case 2:
                                        $res[$i][$fields[$j]] = ($this->mysqli_result($query, $i, $j));
                                        break;
                                }
                        }
                }

                $json = json_encode($res);

                // Versao 2
                if ($indented == false) {
                        return $json;
                }

                $result    = '';
                $pos       = 0;
                $previous  = '';
                $outQuotes = true;

                for ($i = 0; $i <= strlen($json); $i++) {

                        // Next char
                        $char = substr($json, $i, 1);

                        // Inside quote?
                        if ($char == '"' && $previous != '\\') {
                                $outQuotes = !$outQuotes;

                                // End of element? New line and indent

                        } elseif (($char == '}' || $char == ']') && $outQuotes) {
                                $result.= "\n";
                                $pos--;

                                for ($j = 0; $j < $pos; $j++) {
                                        $result.= '    ';
                                }
                        }

                        // Add the character to the result string.
                        $result.= $char;

                        // Beginning of element? New line and indent
                        if (($char == ',' || $char == '{' || $char == '[') && $outQuotes) {
                                $result.= "\n";
                                if ($char == '{' || $char == '[') {
                                        $pos++;
                                }

                                for ($j = 0; $j < $pos; $j++) {
                                        $result.= '    ';
                                }
                        }

                        $previous = $char;
                }

                //Retornando Resultado
                return $result;
        }

        //Metodo Retorna Linhas do Banco de Dados
        public function retorno($query) {
                $this->_query = $query;
                $resultado    = mysqli_fetch_array($query);

                return $resultado;
        }

        //Metodo Retorna Numero de Linhas
        public function numRows($result) {
        
                $rows = @mysqli_num_rows($result);

                if ($rows === null) {
                        return 0;
                } else {

                        return $rows;
                }
        }

        //Metodo Retorna Numero de Colunas
        public function numCols($result) {
                $cols = @mysqli_num_fields($result);

                if (!$cols) {
                        return $this->mysqlRaiseError();
                }

                return $cols;
        }

        //Metodo que retorna o ultimo id de uma inseraao
        public function mysql_lastid() {
                return mysqli_insert_id($this->_link);
        }

        //Metodo Insere dados
        public function mysql_insert($tabela, $dados, $duplicate_key = '', $debug  = false) {
                $this->_debug = $debug;
                
                // Colunas e Valores
                $qtd = count($dados);
                $i   = 0;

                foreach ($dados as $key => $value) {
                        $i++;

                        if ($qtd == $i) {

                                if (($value == 'NULL') or (substr($value,0,3) == '(IF')){

                                        $campos .= "`$key`";
                                        $valores.= "$value";

                                } else {

                                        $campos .= "`$key`";
                                        $valores.= "'$value'";
                                }

                        } else {

                                if (($value == 'NULL') or (substr($value,0,3) == '(IF')){

                                        $campos .= "`$key`,";
                                        $valores.= "$value,";

                                } else {

                                        $campos .= "`$key`,";
                                        $valores.= "'$value',";
                                }
                        }
                }

                if ($duplicate_key != '') {
                        $qtda = count($duplicate_key);
                        if ($qtda > 0) {
                                $campos_key = 'ON DUPLICATE KEY UPDATE ';
                        }

                        $a = 0;
                
                        foreach ($duplicate_key as $key => $value) {
                                $a++;
                                if ($qtda == $a) {
                                        $campos_key.= "$key='$value'";
                                } else {
                                        $campos_key.= "$key='$value',";
                                }
                        }
                }

                $this->_query = "INSERT INTO $tabela ($campos) VALUES ($valores) $campos_key";

                if ($debug == true) {
                        return $this->_query;
                } else {
                        return mysqli_query($this->_link, $this->_query) or die(mysqli_errno());
                }
        }

        //Metodo Inserir Tabela de Select
        public function mysql_insert_table($tabela1, $select,  $where) {

                $this->_query = "INSERT INTO $tabela1 $select WHERE $where";

                return mysqli_query($this->_link, $this->_query) or die(mysqli_errno());
        }

        //Metodo Executa DMS e DDL
        public function mysql_terminal($query) {
                $this->_query = $query;
        
                return mysqli_query($this->_link,$this->_query) or die(mysqli_errno());
        }

        //Metodo Exclui dados
        public function mysql_delete($tabela, $where, $debug = false) {
                $this->_query = "DELETE FROM $tabela WHERE $where";

                if ($debug == true) {
                        return $this->_query;
                } else {
                        return mysqli_query($this->_link,$this->_query) or die(mysqli_errno());
                }
        }

        //Metodo Atualiza Dados
        public function mysql_update($tabela, $dados, $where, $debug = false) {

                $qtd   = count($dados);
                $i     = 0;
                foreach ($dados as $key => $value) {
                        $i++;
                        if ($qtd == $i) {
                                if (($value == 'NULL') or (substr($value,0,3) == '(IF')){
                                        $campos.= "$key=$value";
                                } else {
                                        $campos.= "$key='$value'";
                                }

                        } else {
                                if (($value == 'NULL') or (substr($value,0,3) == '(IF')){
                                        $campos.= "$key=$value,";
                                } else {
                                        $campos.= "$key='$value',";
                                }
                        }
                }

                $this->_query = "UPDATE $tabela SET $campos WHERE $where";

                if ($debug == true) {
                        return $this->_query;
                } else {
                        return mysqli_query($this->_link, $this->_query) or die("ERR: ".mysqli_errno());
                }
        }

        //Metodo fechar conexao
        public function fechar() {

                return mysqli_close($this->_link);
        }

}

?>
